/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Real Time Clock (RTC) Resource Framework API Header File
::   Copyright   :   (C)2004-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file RealTimeClock.h
    \brief The framework's Real Time Clock (RTC) feature. See \ref rtcsupport
*/
    
#ifndef __RESOURCE_RTC_H
#define __RESOURCE_RTC_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <resource.h>
#include <time.h> /* ANSI C time include */
/*----- DEFINES -------------------------------------------------------------------------------------------*/


/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)

/* Name: E_RTCDayOfTheWeek ClassID:ENUMDEC EnumDflt:"Day not set" */
/*! \brief Enumeration describes the day of the week */
typedef enum
{
/*! Sunday */
    RTC_SUNDAY,         /* EnumTxt:"Sunday" */
/*! Monday */
    RTC_MONDAY,         /* EnumTxt:"Monday" */
/*! Tuesday */
    RTC_TUESDAY,        /* EnumTxt:"Tuesday" */
/*! Wednesday */
    RTC_WEDNESDAY,      /* EnumTxt:"Wednesday" */
/*! Thursday */
    RTC_THURSDAY,       /* EnumTxt:"Thursday" */
/*! Friday */
    RTC_FRIDAY,         /* EnumTxt:"Friday" */
/*! Saturday */
    RTC_SATURDAY,       /* EnumTxt:"Saturday" */
} E_RTCDayOfTheWeek;

/* Name: E_RTCMonth ClassID:ENUMDEC EnumDflt:"Month not set" */
/*! \brief Enumeration describes how the month is encoded as a number */
typedef enum
{
/*! The month of January */
    RTC_JANUARY,            /* EnumTxt:"January" */
/*! The month of February */
    RTC_FEBRUARY,           /* EnumTxt:"February" */
/*! The month of March */
    RTC_MARCH,              /* EnumTxt:"March" */
/*! The month of April */
    RTC_APRIL,              /* EnumTxt:"April" */
/*! The month of May */
    RTC_MAY,                /* EnumTxt:"May" */
/*! The month of June */
    RTC_JUNE,               /* EnumTxt:"June" */
/*! The month of July */
    RTC_JULY,               /* EnumTxt:"July" */
/*! The month of August */
    RTC_AUGUST,             /* EnumTxt:"August" */
/*! The month of September */
    RTC_SEPTEMBER,          /* EnumTxt:"September" */
/*! The month of October */
    RTC_OCTOBER,            /* EnumTxt:"October" */
/*! The month of November */
    RTC_NOVEMBER,           /* EnumTxt:"November" */
/*! The month of December */
    RTC_DECEMBER,           /* EnumTxt:"December" */
} E_RTCMonth;

/* Name: E_RTCTimeZone ClassID:ENUMDEC EnumDflt:"Unknown" */
typedef enum
{
    RTC_GMT_MINUS_12,      /* EnumTxt:"International Date Line West" */
    RTC_GMT_MINUS_11,      /* EnumTxt:"Midway Island, Samoa" */
    RTC_GMT_MINUS_10,      /* EnumTxt:"Hawaii" */
    RTC_GMT_MINUS_9,       /* EnumTxt:"Alaska" */
    RTC_GMT_MINUS_8,       /* EnumTxt:"Pacific Time (US & Canada); Tijuana" */
    RTC_GMT_MINUS_7,       /* EnumTxt:"Mountain Time (US & Canada), Arizona, Chihuahua, La Paz, Mazatlan" */
    RTC_GMT_MINUS_6,       /* EnumTxt:"Central Time (US & Canada), Central America" */
    RTC_GMT_MINUS_5,       /* EnumTxt:"Eastern Time (US & Canada), Indiana (East)" */
    RTC_GMT_MINUS_4,       /* EnumTxt:"Caracas, La Paz, Santiago" */
    RTC_GMT_MINUS_3_30,    /* EnumTxt:"Newfoundland" */
    RTC_GMT_MINUS_3,       /* EnumTxt:"Brasilia, Greenland, Buenos Aires, Georgetown" */
    RTC_GMT_MINUS_2,       /* EnumTxt:"Mid-Atlantic" */
    RTC_GMT_MINUS_1,       /* EnumTxt:"Azores, Cape Verdes Island" */
    RTC_GMT,               /* EnumTxt:"Greenwich Mean Time; London, Lisbon, Dublin" */
    RTC_GMT_PLUS_1,        /* EnumTxt:"Amsterdam. Berlin, Bern, Rome, Paris, Madrid, Warsaw" */
    RTC_GMT_PLUS_2,        /* EnumTxt:"Athens, Istanbul, Minsk, Bucharest, Cairo, Jerusalem" */
    RTC_GMT_PLUS_3,        /* EnumTxt:"Kuwait, Riyadh, Moscow, Volgograd" */
    RTC_GMT_PLUS_3_30,     /* EnumTxt:"Tehran" */
    RTC_GMT_PLUS_4,        /* EnumTxt:"Abu Dhabi, Muscat, Baku, Tbilisi" */
    RTC_GMT_PLUS_4_30,     /* EnumTxt:"Kabul" */
    RTC_GMT_PLUS_5,        /* EnumTxt:"Ekaterinburg, Islamabad, Karachi" */
    RTC_GMT_PLUS_5_30,     /* EnumTxt:"Chennai, Kolkata, New Delhi" */
    RTC_GMT_PLUS_5_45,     /* EnumTxt:"Kathmandu" */
    RTC_GMT_PLUS_6,        /* EnumTxt:"Astana, Dhaka" */
    RTC_GMT_PLUS_6_30,     /* EnumTxt:"Rangoon" */
    RTC_GMT_PLUS_7,        /* EnumTxt:"Bangkok, Hanoi, Jakarta" */
    RTC_GMT_PLUS_8,        /* EnumTxt:"Beijing, Hong Kong, Singapore, Perth, Taipei" */
    RTC_GMT_PLUS_9,        /* EnumTxt:"Osaka, Sapporo, Toyko, Seoul, Yakutsk" */
    RTC_GMT_PLUS_9_30,     /* EnumTxt:"Adelaide, Darwin" */
    RTC_GMT_PLUS_10,       /* EnumTxt:"Brisbane, Canberra, Melbourne, Sydney" */
    RTC_GMT_PLUS_11,       /* EnumTxt:"Magadan, Solomon Is., New Caledonia" */
    RTC_GMT_PLUS_12,       /* EnumTxt:"Auckland, Wellington, Marshall Is." */
    RTC_GMT_PLUS_13,       /* EnumTxt:"Nuku'alofa" */

} E_RTCTimeZone;

/* Name: E_RTCDayLightSaving ClassID:ENUMDEC EnumDflt:"Unkown" */
/*! \brief Describes the valid members of the daylight saving atribute */
typedef enum
{
/*! The time does not represent daylight saving */
    RTC_TIME_IS_NOT_DAYLIGHT_SAVING,        /* EnumTxt:"Standard Time" */
/*! The time describes daylight saving */
    RTC_TIME_IS_DAYLIGHT_SAVING,            /* EnumTxt:"Day Light Saving" */
/*! The daylight saving setting is unknown */
    RTC_DAYLIGHT_SAVING_UNKNOWN = 0xFF
} E_RTCDayLightSaving;

/*! \brief The time */
typedef struct
{
    uint2 uYear;                            /*!< The year */
    E_RTCMonth eMonth;                      /*!< The month */
    uint1 uDayOfTheMonth;                   /*!< The day of the month [1..31] */
    uint1 uWeekOfTheYear;                   /*!< The week number of the year [1..52] */
    E_RTCDayOfTheWeek eDayOfTheWeek;        /*!< The day of the week */
    uint1 uHour;                            /*!< The hour of the day [0..23] */
    uint1 uMinute;                          /*!< The minute of the hour [0..59] */
    uint1 uSeconds;                         /*!< The second of the minute [0..59] */
    E_RTCDayLightSaving eDayLightSaving;    /*!< Whether there is day light saving */
    uint2 uMilliSecs;                       /*!< The milliseconds of the second [0..999] */
    uint2 uCompletedDaysThisYear;           /*!< Day since Jan 1 of the year [0..365] */
} S_RTCTime;

#pragma pack()
/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
NativeError_S GetRTCTime(S_RTCTime* out_pTimeBuffer);
NativeError_S SetRTCTime(S_RTCTime const* in_pTimeBuffer);
NativeError_S GetRTCTime_ANSIC(struct tm* out_pTime);
NativeError_S SetRTCTime_ANSIC(const struct tm* in_pTime);

NativeError_S SetRTCTimeLocal(S_RTCTime const* in_pTimeBuffer, E_RTCTimeZone in_eTimeZone);
NativeError_S GetRTCTimeLocalAndTimeZone(S_RTCTime* out_pTimeBuffer, E_RTCTimeZone* out_peTimeZone);
NativeError_S GetRTCTimeLocal(S_RTCTime* out_pTimeBuffer);
NativeError_S GetRTCTimeInTimeZone(S_RTCTime* out_pTimeBuffer, E_RTCTimeZone in_eTimeZone);

NativeError_S GetRTCTimeLocal_ANSIC(struct tm* out_pTime);

E_RTCTimeZone GetRTCTimeZoneFromMinutes(sint2 in_s2OffsetInMinutesFromGMT);
sint2 GetRTCTimeZoneAsMinutes(E_RTCTimeZone in_eTimeZone);

#endif /* __RESOURCE_RTC_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
